################################################################################
################################################################################
#
#			Democratic Deficit
#
#			March, 2015
#			Lucas Leemann and Fabio Wasserfallen
#			l.leemann@ucl.ac.uk & wasserfallen@ipz.uzh.ch
#			
################################################################################
################################################################################

			
#rm(list=ls())

# set new working directory
setwd(your_path)


load("DataForCongruence.RData")



################################################################################
#			Estimating Models
################################################################################


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# First/Main Models
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



# Explanatory variables 9used later for prediction)
X1 <- cbind(1,big.data$dd_stutzer)
X2 <- cbind(1,big.data$gov.cit.gap.1)
X3 <- cbind(1,big.data$dd_stutzer,big.data$gov.cit.gap.1,I(big.data$dd_stutzer*big.data$gov.cit.gap.1))
X4 <- cbind(1,big.data$dd_stutzer,big.data$gov.cit.gap.1,big.data$citizen.opinion.clarity,big.data$gov.opinion.clarity,I(big.data$dd_stutzer*big.data$gov.cit.gap.1))
X7 <- cbind(1,big.data$dd_stutzer,big.data$gov.cit.gap.1,big.data$citizen.opinion.clarity,big.data$gov.opinion.clarity,I(big.data$dd_stutzer*big.data$gov.cit.gap.1), big.data$gdp_capita, big.data$majb07, big.data$german, big.data$Kaiss_Index, big.data$pop2012_100k)

big.data$gdp_capita_100000 <- big.data$gdp_capita/100000
X8 <- cbind(1,big.data$dd_stutzer,big.data$gov.cit.gap.1,big.data$citizen.opinion.clarity,big.data$gov.opinion.clarity,I(big.data$dd_stutzer*big.data$gov.cit.gap.1), big.data$gdp_capita_100000, big.data$majb07, big.data$german, big.data$Kaiss_Index, big.data$pop2012_100k,policies.DDvoteBin3,SVP)




set.seed(123)
## Model 1
mod.con.1 <- bglmer(cit.pol.congruence ~  dd_stutzer + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
# prediction model 1
mod.pred <- mod.con.1
y.lat.fe <- X1 %*% t(fixef(sim(mod.pred)))
RE.Pol <- t(ranef(sim(mod.pred))$policynr[,,1])
RE.policy <- matrix(NA,260,100)
for (i in 1:10){
	a <- 26*(i-1)+1
	b <- 26*i
	RE.policy[c(a:b),] <- RE.Pol[i,]
}
RE.can <- t(ranef(sim(mod.pred))$canton[,,1])
RE.canton <- rbind(RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can)
p.congr <- pnorm(y.lat.fe + RE.policy + RE.canton)
p.mean.congr <- rowMeans(p.congr)
p.pred <- rep(0, length(p.mean.congr))
p.pred[p.mean.congr>0.5] <- 1
cpc <- length(which(big.data$cit.pol.congruence - p.pred ==0))/260
cpc
# [1] 0.71153846 -> 0.71

# model 2
mod.con.2 <- bglmer(cit.pol.congruence ~  gov.cit.gap.1 + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
# prediction model 2
mod.pred <- mod.con.2
y.lat.fe <- X2 %*% t(fixef(sim(mod.pred)))
RE.Pol <- t(ranef(sim(mod.pred))$policynr[,,1])
RE.policy <- matrix(NA,260,100)
for (i in 1:10){
	a <- 26*(i-1)+1
	b <- 26*i
	RE.policy[c(a:b),] <- RE.Pol[i,]
}
RE.can <- t(ranef(sim(mod.pred))$canton[,,1])
RE.canton <- rbind(RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can)
p.congr <- pnorm(y.lat.fe + RE.policy + RE.canton)
p.mean.congr <- rowMeans(p.congr)
p.pred <- rep(0, length(p.mean.congr))
p.pred[p.mean.congr>0.5] <- 1
cpc <- length(which(big.data$cit.pol.congruence - p.pred ==0))/260
cpc
# [1] 0.6846154 -> 0.68

# model 3
mod.con.3 <- bglmer(cit.pol.congruence ~ dd_stutzer +  gov.cit.gap.1  + I(gov.cit.gap.1* dd_stutzer) + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
# prediction model 3
mod.pred <- mod.con.3
y.lat.fe <- X3 %*% t(fixef(sim(mod.pred)))
RE.Pol <- t(ranef(sim(mod.pred))$policynr[,,1])
RE.policy <- matrix(NA,260,100)
for (i in 1:10){
	a <- 26*(i-1)+1
	b <- 26*i
	RE.policy[c(a:b),] <- RE.Pol[i,]
}
RE.can <- t(ranef(sim(mod.pred))$canton[,,1])
RE.canton <- rbind(RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can)
p.congr <- pnorm(y.lat.fe + RE.policy + RE.canton)
p.mean.congr <- rowMeans(p.congr)
p.pred <- rep(0, length(p.mean.congr))
p.pred[p.mean.congr>0.5] <- 1
cpc <- length(which(big.data$cit.pol.congruence - p.pred ==0))/260
cpc
# [1] 0.6884615 -> 0.69 





rob.mod.8 <- glmer(cit.pol.congruence ~   dd_stutzer +  gov.cit.gap.1  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.1*  dd_stutzer) + gdp_capita_100000 + majb07 + german + Kaiss_Index+ pop2012_100k + policies.DDvoteBin3 + SVP + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
mod.pred <- rob.mod.8
y.lat.fe <- X8 %*% t(fixef(sim(mod.pred)))
RE.Pol <- t(ranef(sim(mod.pred))$policynr[,,1])
RE.policy <- matrix(NA,260,100)
for (i in 1:10){
	a <- 26*(i-1)+1
	b <- 26*i
	RE.policy[c(a:b),] <- RE.Pol[i,]
}
RE.can <- t(ranef(sim(mod.pred))$canton[,,1])
RE.canton <- rbind(RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can,RE.can)
p.congr <- pnorm(y.lat.fe + RE.policy + RE.canton)
p.mean.congr <- rowMeans(p.congr)
p.pred <- rep(0, length(p.mean.congr))
p.pred[p.mean.congr>0.5] <- 1
cpc <- length(which(big.data$cit.pol.congruence - p.pred ==0))/260
cpc
# [1] 0.7153846 -> 0.71

# double-checking robustness with "DD in Use - 5 years" (not in paper nor in appendix)
rob.mod.9 <- bglmer(cit.pol.congruence ~   dd_stutzer +  gov.cit.gap.1  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.1*  dd_stutzer) + gdp_capita_100000 + majb07 + german + Kaiss_Index+ pop2012_100k + policies.DDvoteBin5 + SVP + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
summary(rob.mod.9)

# Output of Model Results
print(screenreg(list(mod.con.1,mod.con.2,mod.con.3, rob.mod.8),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
texreg(list(mod.con.1,mod.con.2,mod.con.3, rob.mod.8),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1))


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Robust Models 1 (appendix, first table A6)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

big.data$sachrecht_grundl_sk_100 <- big.data$sachrecht_grundl_sk_100/100

rob.mod.1 <- bglmer(cit.pol.congruence ~   sachrecht_grundl_sk_100 + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

rob.mod.2 <- bglmer(cit.pol.congruence ~    gov.cit.gap.1  + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

rob.mod.3 <- bglmer(cit.pol.congruence ~   sachrecht_grundl_sk_100 +  gov.cit.gap.1  + I(gov.cit.gap.1* sachrecht_grundl_sk_100) +(1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

rob.mod.6 <- bglmer(cit.pol.congruence ~   sachrecht_grundl_sk_100 +  gov.cit.gap.1  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.1* sachrecht_grundl_sk_100) + gdp_capita_100000 + majb07 + german + Kaiss_Index+ pop2012_100k + policies.DDvoteBin3 + SVP + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

# double-checking robustness with "DD in Use - 5 years" (not in paper nor in appendix)
rob.mod.7 <- bglmer(cit.pol.congruence ~   sachrecht_grundl_sk_100 +  gov.cit.gap.1  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.1* sachrecht_grundl_sk_100) + gdp_capita_100000 + majb07 + german + Kaiss_Index+ pop2012_100k + policies.DDvoteBin5 + SVP + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
summary(rob.mod.7)


# Output of Model Results
print(screenreg(list(rob.mod.1,rob.mod.2,rob.mod.3,rob.mod.6),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
texreg(list(rob.mod.1,rob.mod.2,rob.mod.3,rob.mod.6),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1))
print("Note: sachrecht_grundl_sk_100 is the alternative DD measure from Vatter et al. (2010).")

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Robust Models 2 (appendix, second table A6)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

rob.mod.21 <- bglmer(cit.pol.congruence ~   dd_stutzer + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

rob.mod.22 <- bglmer(cit.pol.congruence ~    gov.cit.gap.4  + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

rob.mod.23 <- bglmer(cit.pol.congruence ~   dd_stutzer +  gov.cit.gap.4  + I(gov.cit.gap.4* dd_stutzer) +(1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)


rob.mod.26 <- bglmer(cit.pol.congruence ~   dd_stutzer +  gov.cit.gap.4  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.4* dd_stutzer) + gdp_capita_100000 + majb07 + german + Kaiss_Index+ pop2012_100k+ policies.DDvoteBin3 + SVP  + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

# double-checking robustness with "DD in Use - 5 years" (not in paper nor in appendix)
rob.mod.27 <- bglmer(cit.pol.congruence ~   dd_stutzer +  gov.cit.gap.4  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.4* dd_stutzer) + gdp_capita_100000 + majb07 + german + Kaiss_Index+ pop2012_100k+ policies.DDvoteBin3 + SVP  + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
summary(rob.mod.27)

# Output of Model Results
print(screenreg(list(rob.mod.21,rob.mod.22,rob.mod.23,rob.mod.26),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
texreg(list(rob.mod.21,rob.mod.22,rob.mod.23,rob.mod.26),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1))
print("Note: gov.cit.gap.4 is the alternative gap measure described in the appendix.")





#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
### Instrumental Variable Approach for Model 3 (manuscript, table 2, model 3)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


HDDI <- big.data$HDDI_18801900[1:26]
stutzer <- big.data$dd_stutzer[1:26]
X <- big.data$gov.cit.gap.1[1:26]


summary(lm(stutzer[-26] ~ HDDI[-26] + X[-26]))
summary(lm(stutzer[-26] ~  X[-26]))
mod1 <- (lm(stutzer[-26] ~ HDDI[-26] + X[-26]))
mod2 <- (lm(stutzer[-26] ~  X[-26]))
anova(mod2,mod1)


mod.1st <- (lm(dd_stutzer ~ HDDI_18801900 + gov.cit.gap.1, data= big.data[1:25,]))
DD.ivLucas <- predict(mod.1st)
DD.ivLucas <- rep(c(DD.ivLucas,NA),10)
mod2L <- bglmer(cit.pol.congruence ~ DD.ivLucas  +  gov.cit.gap.1  + I(gov.cit.gap.1* DD.ivLucas) + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
p.hat <- pnorm(predict(mod2L))
y.hat <- rep(0,length(p.hat))
y.hat[p.hat>0.5] <- 1
real.y <- big.data$cit.pol.congruence
jura <- rep(c(rep(1,25),NA),10) # jura is missing
real.y <- real.y[which(jura==1)] 
table(y.hat,real.y)


# Get second stage right (confidence intervals)
beta <- coef(lm(stutzer[-26] ~ HDDI[-26] + X[-26]))
varL <- vcov(lm(stutzer[-26] ~ HDDI[-26] + X[-26]))

set.seed(111)
BETA <- mvrnorm(500, beta, varL)

DD.IV.sim <- cbind(1,HDDI[-26],X[-26]) %*% t(BETA)

BBETA <- rep(0,4)
KKANT <- rep(0,26)
PPOLI <- rep(0,10)
for (q in 1:500){
	IVDD <- DD.IV.sim[,q]
	IVDD <- rep(c(IVDD,NA),10)
	m1 <- rob.mod.end.2 <- bglmer(cit.pol.congruence ~  IVDD +  gov.cit.gap.1  + I(gov.cit.gap.1*  IVDD) + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
	beta <- fixef(m1)
	vari <- vcov(m1)
	BETA <- mvrnorm(1000,beta,vari)
	BBETA <- rbind(BBETA, BETA)
	KANT <- ranef(m1)$cantonnr
	KKANT <- rbind(KKANT,KANT)
	POLI <- ranef(m1)$policynr
	PPOLI <- rbind(PPOLI,POLI)
	if (q%%10==0) print(q)
}


betaIV <-  colMeans(BBETA)
seIV <- sqrt(colVars(BBETA))
BBETA.sorted <- apply(BBETA,2,sort)

print("Table 2 -- Model 6 and Model 3 IV")
print(screenreg(list(mod.1st, m1), include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
print(screenreg(list(mod2L), include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
print("Uncertainty needs to be adjusted - summary statistics of the simulations provided below")
print(BBETA.sorted[c(12500,250000,487500),])





#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
### Instrumental Variable Approach for Big Model (manuscript, table 2, model 4)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


X <- cbind(big.data$gov.cit.gap.1[1:26], big.data$citizen.opinion.clarity[1:26], big.data$gov.opinion.clarity[1:26], big.data$gdp_capita[1:26], big.data$majb07[1:26], big.data$german[1:26], big.data$Kaiss_Index[1:26], big.data$pop2012_100k[1:26], big.data$policies.DDvoteBin3[1:26], big.data$SVP[1:26])

Xsm <- X[,1]

summary(lm(stutzer[-26] ~ HDDI[-26] + Xsm[-26]))
summary(lm(stutzer[-26] ~  Xsm[-26]))
mod1 <- (lm(stutzer[-26] ~ HDDI[-26] + Xsm[-26]))
mod2 <- (lm(stutzer[-26] ~  Xsm[-26]))
anova(mod2,mod1)


mod.1st <- (lm(dd_stutzer ~ HDDI_18801900 + gov.cit.gap.1, data= big.data[1:25,]))
DD.ivLucas <- predict(mod.1st)
DD.ivLucas <- rep(c(DD.ivLucas,NA),10)
mod2L <- bglmer(cit.pol.congruence ~ DD.ivLucas  +  gov.cit.gap.1  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.1* DD.ivLucas) + gdp_capita_100000 + majb07 + german + Kaiss_Index + pop2012_100k+ policies.DDvoteBin3 + SVP + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
p.hat <- pnorm(predict(mod2L))
y.hat <- rep(0,length(p.hat))
y.hat[p.hat>0.5] <- 1
real.y <- big.data$cit.pol.congruence
jura <- rep(c(rep(1,25),NA),10) # jura is missing
real.y <- real.y[which(jura==1)] 
table(y.hat,real.y)


# Get second stage right (confidence intervals)
beta <- coef(lm(stutzer[-26] ~ HDDI[-26] + Xsm[-26]))
varL <- vcov(lm(stutzer[-26] ~ HDDI[-26] + Xsm[-26]))

set.seed(111)
BETA <- mvrnorm(500, beta, varL)

DD.IV.sim <- cbind(1,HDDI[-26],Xsm[-26]) %*% t(BETA)

vBBETA <- rep(0,13)
KKANT <- rep(0,26)
PPOLI <- rep(0,10)
for (q in 1:500){
	IVDD <- DD.IV.sim[,q]
	IVDD <- rep(c(IVDD,NA),10)
	m2 <- rob.mod.end.2 <- bglmer(cit.pol.congruence ~  IVDD +  gov.cit.gap.1  + citizen.opinion.clarity + gov.opinion.clarity + I(gov.cit.gap.1*  IVDD)+ gdp_capita_100000 + majb07 + german + Kaiss_Index + pop2012_100k+ policies.DDvoteBin3 + SVP + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)
	beta <- fixef(m2)
	vari <- vcov(m2)
	BETA <- mvrnorm(1000,beta,vari)
	vBBETA <- rbind(vBBETA, BETA)
	KANT <- ranef(m2)$cantonnr
	KKANT <- rbind(KKANT,KANT)
	POLI <- ranef(m2)$policynr
	PPOLI <- rbind(PPOLI,POLI)
	if (q%%10==0) print(q)
}


betaIV <-  colMeans(vBBETA)
seIV <- sqrt(colVars(vBBETA))
vBBETA.sorted <- apply(vBBETA,2,sort)

print("Table 2 -- Model 6 and Model 4 IV")
print(screenreg(list(mod.1st, m1, m2), include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
print(screenreg(list(mod2L), include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
print("Uncertainty needs to be adjusted - summary statistics of the simulations provided below")
print(vBBETA.sorted[c(round(0.025*500001,0),round(0.5*500001,0),round(0.975*500001,0)),])



texreg(list(mod.1st, m1, m2), include.pvalues=TRUE ,stars = c(0.01,0.05,0.1),custom.model.names=c("1st Stage", "2nd Stage", "2nd Stage"))

betaIV
seIV





#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
### Analyzing First and Second Dimension Issues
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# Figure 6 in appendix (A7)
attach(big.data)
###### Code policies as first, second and mixture/unknown dimension

# First: 2,3,9
# Second: 1,4,5  
# Residual (unknown): 6,7,8,10

policy.dim <- c(rep(2,26),rep(1,26),rep(1,26),rep(2,26),rep(2,26),rep(3,26),rep(3,26),rep(3,26),rep(1,26),rep(3,26))
data.dim <- cbind(cit.pol.congruence, dd_stutzer, gov.cit.gap.1, gov.cit.gap.abs, policy.dim)
data.dim <- as.data.frame(data.dim)



### Show absolute elite-citizen pref deviation for three groups


data.policies.1dim <- data.dim[policy.dim==1,]
gap.abs.1dim <- data.policies.1dim$gov.cit.gap.abs

data.policies.2dim <- data.dim[policy.dim==2,]
gap.abs.2dim <- data.policies.2dim$gov.cit.gap.abs

data.policies.3dim <- data.dim[policy.dim==3,]
gap.abs.3dim <- data.policies.3dim$gov.cit.gap.abs


plot(c(1,2,3), c(summary(gap.abs.1dim)[2],summary(gap.abs.3dim)[5],summary(gap.abs.2dim)[5]), type="n", axes=F, xlab="Policy Dimensions", ylab="Government-Voter Preference Gap", cex.lab=1.2)

box()
axis(2, cex.axis=1.1)
axis(1,at=1.3,1,cex.axis=1.1)
axis(1,at=2,2,cex.axis=1.1)
axis(1,at=2.7,"Residual",cex.axis=1.1)

points(1.3,summary(gap.abs.1dim)[3], cex=2.5, col= "grey", pch=19)
segments(1.3,summary(gap.abs.1dim)[2],1.3,summary(gap.abs.1dim)[5], col="grey", lwd=5)

points(2,summary(gap.abs.2dim)[4], cex=2.5, col= "grey", pch=19)
segments(2,summary(gap.abs.2dim)[2],2,summary(gap.abs.2dim)[5], col="grey", lwd=5)

points(2.7,summary(gap.abs.3dim)[4], cex=2.5, col= "grey", pch=19)
segments(2.7,summary(gap.abs.3dim)[2],2.7,summary(gap.abs.3dim)[5], col="grey", lwd=5)


# Table A7 in appendix (A7)


mod.pol.dim1 <- bglmer(cit.pol.congruence ~ dd_stutzer + gov.cit.gap.1 + policy.dim + (1|cantonnr)+ (1|policynr), family=binomial(link=probit), data=big.data)

mod.pol.dim2 <- bglmer(cit.pol.congruence ~ dd_stutzer + gov.cit.gap.1 + policy.dim + I(policy.dim*dd_stutzer) + (1|cantonnr) + (1|policynr), family=binomial(link=probit), data=big.data)

print(screenreg(list(mod.pol.dim1,mod.pol.dim2),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
texreg(list(mod.pol.dim1,mod.pol.dim2),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1))








################################################################################
#			Plot / Interpretation
################################################################################



#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Plot (based on Model 3) -- Figure 2 in manuscript
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
cit.pre <- seq(0,1,length.out=100)
gov.pre <- rep(0.5, 100)
cit.cla <- abs(cit.pre-0.5)
gov.cla <- abs(gov.pre-0.5)
gap1 <- abs(cit.pre-gov.pre)
gap1[(cit.pre>.5&gov.pre>.5)|(cit.pre<.5&gov.pre<.5)] <- 0

set.seed(111)
dd1 <- 4.5
dd3 <- 7.5
### adding uncertainty:
set.seed(111)
S <- 1000
beta <- fixef(mod.con.3) #4
varcov <- vcov(mod.con.3) #4
BETA <- mvrnorm(S,beta,varcov)

x.mod.con.31 <- cbind(1,rep(dd1,100),gap1,dd1*gap1)#,cit.cla,gov.cla)
x.mod.con.32 <- cbind(1,rep(dd3,100),gap1,dd3*gap1)#,cit.cla,gov.cla)

# predictions for policy (RE: -0.36, like policy #4)
pred.1 <- pnorm(x.mod.con.31%*%t(BETA)-0.36)
pred.3 <- pnorm(x.mod.con.32%*%t(BETA)-0.36)

diff.13.at60 <- pred.1[60,]-pred.3[60,]
sort(diff.13.at60)[c(25,975)]

lwd.sm <- 2
pred.1star <- t(apply(pred.1,1,sort))
pred.3star <- t(apply(pred.3,1,sort))

cib <- 0.1	 # Define level for CI
lb <- round((dim(BETA)[1] * cib)/2)	# lb and ub define which predictions to be plotted
ub <- dim(BETA)[1] - lb # >and are based on "cib"

#par(family="CMU Serif")
plot(seq(0,1,length.out=100),rowMedians(pred.1), ylab="Predicted Probability of Policy Congruence", xlab="Government-Voter Preference Deviation", type="l", lwd=2, ylim=c(0,1), xlim=c(0.53,1),col=rgb(238, 160, 238, 255, maxColorValue=255),xaxt="n",cex.lab=1.4)
axis(1,at=c(0.5,0.6,0.7,0.8,0.9,1.0), labels=c(0.0,0.1,0.2,0.3,0.4,0.5))
	for (i in lb:ub){	 # plot every prediction between "lb" and "ub"
				points(seq(0,1,length.out=100),jitter(pred.1star[,i], amount=0.02), type="l", col=rgb(160,32,240,10,maxColorValue=255), lwd=1)
				}
	for (i in lb:ub){
				points(seq(0,1,length.out=100),jitter(pred.3star[,i], amount=0.02), type="l", col=rgb(30,144,255,10,maxColorValue=255), lwd=1)
				}
points(seq(0,1,length.out=100),rowMedians(pred.3),col=rgb(30,144,255,255,maxColorValue=255), lwd=4, type="l", lty=3)
points(seq(0,1,length.out=100),rowMedians(pred.1),  type="l", lwd=4,col=rgb(160,32, 240, 255, maxColorValue=255))
legend(0.85,0.77,legend=c("Extensive DD"), col=c(rgb(30,144,255,255,maxColorValue=255)), bty="n",lwd=c(4), lty=3)
legend(0.85,0.28,legend=c("Limited DD"), col=c(rgb(160,32, 240, 255, maxColorValue=255)), bty="n",lwd=c(4))







# probabilities for text

diff1 <- pred.3[50,] - pred.1[50,]
print(sort(diff1)[c(25,500,975)])
#sort(diff1)[c(50,500,950)]
diff2 <- pred.3[60,] - pred.1[60,]
print(sort(diff2)[c(25,500,975)])
#sort(diff2)[c(50,500,950)]
diffdiff <- diff2-diff1
print(sort(diffdiff)[c(25,500,975)])
#sort(diffdiff)[c(50,500,950)]



################################################################################
#			Elite Preferences
################################################################################

data3 <- read.dta("responses_all_gov1.dta",convert.factors=FALSE)
attach(data3)

mod1 <- lm(data3$que_1_bin ~  factor(data3$party_num))
mod2 <- lm(data3$que_1_bin ~  factor(data3$cantonnr))
mod3 <- lm(data3$que_1_bin ~  factor(data3$party_num)+factor(data3$cantonnr))

summary(mod1)
summary(mod2)
summary(mod3)

anova(mod1,mod3)

print(screenreg(list(mod1,mod2,mod3),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1)))
texreg(list(mod1,mod2,mod3),include.pvalues=TRUE ,stars = c(0.01,0.05,0.1))

print(BIC(lm(data3$que_1_bin ~  factor(data3$party_num))))
print(BIC(lm(data3$que_1_bin ~  factor(data3$cantonnr))))
print(BIC(lm(data3$que_1_bin ~  factor(data3$party_num)+factor(data3$cantonnr) )))


install.packages("lme4")



